<?php
/* --------------------------------------------------------------
   LanguageMapper.php 2020-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Repositories;

use Gambio\Core\Language\Language;
use Gambio\Core\Language\LanguageFactory;
use Gambio\Core\Language\Languages;

/**
 * Class LanguageMapper
 *
 * @package Gambio\Core\Language\Repositories
 */
class LanguageMapper
{
    /**
     * @var LanguageFactory
     */
    private $factory;
    
    
    /**
     * LanguageMapper constructor.
     *
     * @param LanguageFactory $factory
     */
    public function __construct(LanguageFactory $factory)
    {
        $this->factory = $factory;
    }
    
    
    /**
     * @param array $dbData
     *
     * @return Language
     */
    public function mapLanguage(array $dbData): Language
    {
        return $this->factory->createLanguage((int)$dbData['languages_id'],
                                              $dbData['code'],
                                              $dbData['name'],
                                              $dbData['language_charset'],
                                              $dbData['directory']);
    }
    
    
    /**
     * @param array $languagesDbData
     *
     * @return Languages
     */
    public function mapLanguages(array $languagesDbData): Languages
    {
        
        $languagesData = array_map(static function (array $dbData) {
            return [
                'id'        => (int)$dbData['languages_id'],
                'code'      => $dbData['code'],
                'name'      => $dbData['name'],
                'charset'   => $dbData['language_charset'],
                'directory' => $dbData['directory'],
            ];
        },
            $languagesDbData);
        
        return $this->factory->createLanguages($languagesData);
    }
}